#ifdef GL_ES
precision mediump float;
#endif

uniform sampler2D u_Tex0;
uniform float u_Time;
varying vec2 v_TexCoord;

void main() {
  vec4 c = texture2D(u_Tex0, v_TexCoord);
  if (c.a < 0.01) { gl_FragColor = c; return; }

  float pulse = 0.5 + 0.5 * sin(u_Time * 2.160);
  vec3 tint = vec3(0.950, 1.000, 1.300);

  vec3 outc = mix(c.rgb, c.rgb * tint, 0.125 * pulse);

  gl_FragColor = vec4(outc, c.a);
}
