#ifdef GL_ES
precision mediump float;
#endif

uniform sampler2D u_Tex0;
uniform float u_Time;
varying vec2 v_TexCoord;

void main() {
  vec4 c = texture2D(u_Tex0, v_TexCoord);
  if (c.a < 0.01) { gl_FragColor = c; return; }

  float pulse = 0.5 + 0.5 * sin(u_Time * 2.400);
  vec3 tint = vec3(1.300, 0.950, 1.300);

  vec3 outc = mix(c.rgb, c.rgb * tint, 0.155 * pulse);

  // Soft sheen (tiers 6+)
  float wave = 0.5 + 0.5 * sin((v_TexCoord.x + v_TexCoord.y) * 20.0 + u_Time * 3.40);
  outc += tint * (0.05 * wave);

  gl_FragColor = vec4(outc, c.a);
}
