#ifdef GL_ES
precision mediump float;
#endif

uniform sampler2D u_Tex0;
uniform float u_Time;
varying vec2 v_TexCoord;

void main() {
  vec4 c = texture2D(u_Tex0, v_TexCoord);
  if (c.a < 0.01) { gl_FragColor = c; return; }

  float pulse = 0.5 + 0.5 * sin(u_Time * 2.880);
  vec3 tint = vec3(1.400, 0.950, 0.950);

  vec3 outc = mix(c.rgb, c.rgb * tint, 0.215 * pulse);

  // Soft sheen (tiers 6+)
  float wave = 0.5 + 0.5 * sin((v_TexCoord.x + v_TexCoord.y) * 24.0 + u_Time * 4.00);
  outc += tint * (0.05 * wave);

  // Diagonal glint sweep (tiers 8+)
  float d = v_TexCoord.x + v_TexCoord.y;
  float sweep = smoothstep(0.48, 0.52, fract(d * 0.9 + u_Time * 0.65));
  outc += vec3(1.25, 1.25, 1.35) * (0.10 * sweep);

  gl_FragColor = vec4(outc, c.a);
}
