#ifdef GL_ES
precision mediump float;
#endif

uniform sampler2D u_Tex0;
uniform float u_Time;
varying vec2 v_TexCoord;

float hash(vec2 p) {
  return fract(sin(dot(p, vec2(127.1, 311.7))) * 43758.5453);
}

void main() {
  vec4 c = texture2D(u_Tex0, v_TexCoord);
  if (c.a < 0.01) { gl_FragColor = c; return; }

  float pulse = 0.5 + 0.5 * sin(u_Time * 3.55);
  vec3 tint = vec3(1.650, 1.350, 0.850);

  vec3 outc = mix(c.rgb, c.rgb * tint, 0.30 * pulse);

  float wave = 0.5 + 0.5 * sin((v_TexCoord.x + v_TexCoord.y) * 29.0 + u_Time * 4.85);
  outc += tint * (0.06 * wave);

  float d = v_TexCoord.x + v_TexCoord.y;
  float sweep = smoothstep(0.48, 0.52, fract(d * 0.9 + u_Time * 0.82));
  outc += vec3(1.25, 1.25, 1.35) * (0.11 * sweep);

  vec2 cell = floor(v_TexCoord * 54.0);
  float n = hash(cell + floor(u_Time * 14.0));
  float sp = smoothstep(0.905, 1.0, n) * 0.24;
  outc += vec3(1.2, 1.2, 1.35) * sp;

  gl_FragColor = vec4(outc, c.a);
}
