// Soft glow for UIItem / sprite-like widgets.
// Adds a faint outer glow around opaque pixels.
const float px = 1.0 / 64.0;

uniform float u_Time;
uniform sampler2D u_Tex0;
varying vec2 v_TexCoord;

float sampleAlpha(vec2 uv) {
  return texture2D(u_Tex0, uv).a;
}

void main() {
  vec4 col = texture2D(u_Tex0, v_TexCoord);
  float a = col.a;

  // 8-neighborhood alpha for glow
  float s =
      sampleAlpha(v_TexCoord + vec2( px, 0.0)) +
      sampleAlpha(v_TexCoord + vec2(-px, 0.0)) +
      sampleAlpha(v_TexCoord + vec2(0.0,  px)) +
      sampleAlpha(v_TexCoord + vec2(0.0, -px)) +
      sampleAlpha(v_TexCoord + vec2( px,  px)) +
      sampleAlpha(v_TexCoord + vec2(-px,  px)) +
      sampleAlpha(v_TexCoord + vec2( px, -px)) +
      sampleAlpha(v_TexCoord + vec2(-px, -px));

  float glow = clamp(s * 0.20, 0.0, 1.0) * (1.0 - a);

  // Slight time shimmer so it doesn't look static
  float t = (sin(u_Time * 2.4) + 1.0) * 0.5;
  vec3 glowColor = mix(vec3(0.15, 0.55, 1.00), vec3(1.00, 0.75, 0.15), t);

  vec3 outRgb = col.rgb + glowColor * glow * 0.6;
  gl_FragColor = vec4(outRgb, max(a, glow * 0.85));
}
