// Pulse border for UIItem / sprite-like widgets.
// Makes a bright animated edge when alpha transitions from 0->1.
const float px = 1.0 / 64.0;

uniform float u_Time;
uniform sampler2D u_Tex0;
varying vec2 v_TexCoord;

float a(vec2 uv) { return texture2D(u_Tex0, uv).a; }

void main() {
  vec4 col = texture2D(u_Tex0, v_TexCoord);

  float center = col.a;
  float edge = a(v_TexCoord + vec2(px,0.0)) +
               a(v_TexCoord + vec2(-px,0.0)) +
               a(v_TexCoord + vec2(0.0,px)) +
               a(v_TexCoord + vec2(0.0,-px));

  // Edge pixels: center transparent but neighbors opaque
  float isEdge = step(0.02, edge) * (1.0 - step(0.10, center));

  float pulse = (sin(u_Time * 7.0) + 1.0) * 0.5;
  vec3 edgeColor = mix(vec3(0.25, 1.0, 0.35), vec3(1.0, 0.35, 0.75), pulse);

  vec3 rgb = col.rgb + edgeColor * isEdge * (0.35 + 0.65 * pulse);
  float outA = max(col.a, isEdge * 0.9);
  gl_FragColor = vec4(rgb, outA);
}
