// "Rarity tint" style: gently shifts hue and boosts saturation/contrast.
// Good for making items pop without full rainbow effects.
uniform float u_Time;
uniform sampler2D u_Tex0;
varying vec2 v_TexCoord;

vec3 rgb2hsv(vec3 c) {
  vec4 K = vec4(0.0, -1.0/3.0, 2.0/3.0, -1.0);
  vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
  vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));
  float d = q.x - min(q.w, q.y);
  float e = 1.0e-10;
  return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsv2rgb(vec3 c) {
  vec3 p = abs(fract(c.xxx + vec3(0.0, 2.0/3.0, 1.0/3.0)) * 6.0 - 3.0);
  vec3 rgb = clamp(p - 1.0, 0.0, 1.0);
  return c.z * mix(vec3(1.0), rgb, c.y);
}

void main() {
  vec4 col = texture2D(u_Tex0, v_TexCoord);
  if (col.a < 0.01) { gl_FragColor = col; return; }

  vec3 hsv = rgb2hsv(col.rgb);

  // Slow hue drift (subtle)
  float drift = 0.02 * sin(u_Time * 0.8);
  hsv.x = fract(hsv.x + drift);

  // Boost saturation and value a bit
  hsv.y = clamp(hsv.y * 1.15 + 0.05, 0.0, 1.0);
  hsv.z = clamp(hsv.z * 1.05, 0.0, 1.0);

  vec3 rgb = hsv2rgb(hsv);

  // Mild contrast
  rgb = (rgb - 0.5) * 1.10 + 0.5;

  gl_FragColor = vec4(rgb, col.a);
}
